/*
 * Decompiled with CFR 0.152.
 */
package pub.pigeon.yggdyy.hexcreating.blocks.iotareader;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.ListIota;
import at.petrak.hexcasting.api.item.HexHolderItem;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.common.lib.HexSounds;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import pub.pigeon.yggdyy.hexcreating.api.iotanet.IotaNetProcessor;
import pub.pigeon.yggdyy.hexcreating.api.iotanet.IotaPack;
import pub.pigeon.yggdyy.hexcreating.api.iotanet.IotaTerminal;
import pub.pigeon.yggdyy.hexcreating.blocks.iotareader.IotaReaderBlockEntity;

public class IotaReadBehaviour
extends BeltProcessingBehaviour {
    public IotaReaderBlockEntity reader;
    public long needReadTime = 0L;
    public long haveReadTime = 0L;
    public static String NEED_READ_TIME_KEY = "need_read_time";
    public static String HAVE_READ_TIME_KEY = "have_read_time";
    public Iota targetIota = null;
    public static String TARGET_IOTA_KEY = "need_read_iota";
    public int particleRenderTimer = 4;
    public static double PARTICLE_RENDER_BOTTOM_OFFSET = -1.5;
    public static double PARTICLE_RENDER_TOP_OFFSET = -1.2;

    public IotaReadBehaviour(IotaReaderBlockEntity be) {
        super((SmartBlockEntity)be);
        this.reader = be;
        this.whenItemEnters(this::itemEnter);
        this.whileItemHeld(this::itemHeld);
    }

    private BeltProcessingBehaviour.ProcessingResult itemHeld(TransportedItemStack transportedItemStack, TransportedItemStackHandlerBehaviour handler) {
        if (this.reader.method_10997() == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        this.haveReadTime = (long)((float)this.haveReadTime + Math.abs(this.reader.getSpeed()));
        if (this.haveReadTime >= this.needReadTime) {
            List<class_2338> toList = this.reader.getCanSendIotaPackToPos();
            IotaPack pack = IotaPack.createNew(this.targetIota);
            for (class_2338 p : toList) {
                IotaNetProcessor.trySendIotaPack(pack.copyWithSameId(), new IotaTerminal((class_2586)this.blockEntity, 0), p, (class_3218)this.blockEntity.method_10997());
            }
            this.needReadTime = 0L;
            this.haveReadTime = 0L;
            this.targetIota = null;
            this.reader.method_10997().method_8396(null, this.reader.method_11016(), HexSounds.READ_LORE_FRAGMENT, class_3419.field_15245, 1.0f, 1.0f);
            this.reader.sync();
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        this.reader.sync();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    private BeltProcessingBehaviour.ProcessingResult itemEnter(@NotNull TransportedItemStack transportedItemStack, TransportedItemStackHandlerBehaviour handler) {
        class_1792 class_17922 = transportedItemStack.stack.method_7909();
        if (class_17922 instanceof HexHolderItem) {
            HexHolderItem item = (HexHolderItem)class_17922;
            if (item.hasHex(transportedItemStack.stack)) {
                l = item.getHex(transportedItemStack.stack, (class_3218)handler.getWorld());
                if (l.size() == 0) {
                    return BeltProcessingBehaviour.ProcessingResult.PASS;
                }
                if (l.size() == 1) {
                    this.targetIota = (Iota)l.get(0);
                    this.haveReadTime = 0L;
                    this.needReadTime = this.getIotaReadNeedTimeArg() * 128L * (long)this.targetIota.size();
                } else {
                    this.targetIota = new ListIota((List)l);
                    this.haveReadTime = 0L;
                    this.needReadTime = this.getIotaReadNeedTimeArg() * 128L * (long)this.targetIota.size();
                }
                this.reader.method_10997().method_8396(null, this.reader.method_11016(), HexSounds.CAST_HERMES, class_3419.field_15245, 1.0f, 1.0f);
                this.reader.sync();
                return BeltProcessingBehaviour.ProcessingResult.HOLD;
            }
        } else {
            l = transportedItemStack.stack.method_7909();
            if (l instanceof IotaHolderItem) {
                IotaHolderItem item = (IotaHolderItem)l;
                Iota iota = item.readIota(transportedItemStack.stack, (class_3218)handler.getWorld());
                if (iota == null) {
                    return BeltProcessingBehaviour.ProcessingResult.PASS;
                }
                this.targetIota = iota;
                this.haveReadTime = 0L;
                this.needReadTime = this.getIotaReadNeedTimeArg() * 128L * (long)this.targetIota.size();
                this.reader.method_10997().method_8396(null, this.reader.method_11016(), HexSounds.CAST_THOTH, class_3419.field_15245, 1.0f, 1.0f);
                this.reader.sync();
                return BeltProcessingBehaviour.ProcessingResult.HOLD;
            }
        }
        return BeltProcessingBehaviour.ProcessingResult.PASS;
    }

    public long getIotaReadNeedTimeArg() {
        return 20L;
    }

    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.needReadTime = nbt.method_10545(NEED_READ_TIME_KEY) ? nbt.method_10537(NEED_READ_TIME_KEY) : 0L;
        long l = this.haveReadTime = nbt.method_10545(HAVE_READ_TIME_KEY) ? nbt.method_10537(HAVE_READ_TIME_KEY) : 0L;
        if (!clientPacket && nbt.method_10545(TARGET_IOTA_KEY)) {
            this.targetIota = IotaType.deserialize((class_2487)nbt.method_10562(TARGET_IOTA_KEY), (class_3218)((class_3218)this.reader.method_10997()));
        }
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.method_10544(NEED_READ_TIME_KEY, this.needReadTime);
        nbt.method_10544(HAVE_READ_TIME_KEY, this.haveReadTime);
        if (!clientPacket && this.targetIota != null) {
            nbt.method_10566(TARGET_IOTA_KEY, (class_2520)IotaType.serialize((Iota)this.targetIota));
        }
    }

    public void tick() {
        if (this.reader.method_10997() != null && this.reader.method_10997().field_9236) {
            if (this.needReadTime <= 0L) {
                this.particleRenderTimer = 4;
            } else {
                ++this.particleRenderTimer;
                if (this.particleRenderTimer >= 5) {
                    this.particleRenderTimer = 0;
                    class_243 p = this.reader.method_11016().method_46558();
                    double y = (double)this.haveReadTime * 1.0 / (double)this.needReadTime * (PARTICLE_RENDER_TOP_OFFSET - PARTICLE_RENDER_BOTTOM_OFFSET) + p.field_1351 + PARTICLE_RENDER_BOTTOM_OFFSET;
                    this.reader.method_10997().method_8406((class_2394)class_2398.field_11249, p.field_1352, y, p.field_1350, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

